local assets=
{ 
    Asset("ANIM", "anim/wand_k.zip"),
	Asset("ANIM", "anim/swap_wand_k.zip"),
    Asset("ATLAS", "images/inventoryimages/wand_k.xml"),
	Asset("IMAGE", "images/inventoryimages/wand_k.tex"),
}

-- local dam = 150

local prefabs =
{
	"warsaw939",
	"vog25",
	"explode_small",
}

local function onattack_tunder(inst, owner, target)
	if owner.components.inventory:Has("warsaw939", 1) then
	inst.SoundEmitter:PlaySound("shots/gunshot/tunders14shot")	
	else if owner.components.inventory:Has("vog25", 1) then
	inst.SoundEmitter:PlaySound("shots/gunshot/bulldog6shot")	

	end
	end
end

local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "swap_wand_k", "wand")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
end

local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
end



local function fn(colour)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter() 

    ---- 
    MakeInventoryPhysics(inst)
    
	
    anim:SetBank("wand")
    anim:SetBuild("wand_k")
    anim:PlayAnimation("idle")

	
	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(12)
    inst.components.weapon:SetOnAttack(onattack_tunder)
    inst.components.weapon:SetProjectile("warsaw939")
	
	inst:AddComponent("inspectable")
		
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wand_k"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wand_k.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

	
	inst.HasAmmo = function(inst, owner)
		if (owner and owner.components.inventory and owner.components.inventory:Has("warsaw939", 1))or (owner:HasTag("ai"))		then
			owner.components.inventory:ConsumeByName("warsaw939", 1)
	inst.components.weapon:SetProjectile("warsaw939")
	inst.components.weapon:SetDamage(76)
			return true		
		else if(owner and owner.components.inventory and owner.components.inventory:Has("vog25", 1))	then
		owner.components.inventory:ConsumeByName("vog25", 1)
	inst.components.weapon:SetProjectile("vog25")
	inst.components.weapon:SetDamage(143)
		return true
		end
		return false
	end
	end
	
	-- inst.HasAmmo = function(inst, owner)
		-- if (owner and owner.components.inventory and owner.components.inventory:Has("warsaw939", 1))or (owner:HasTag("ai"))		then
			-- return true
		-- end
		-- return false
	-- end
	
    return inst
end

return  Prefab("common/inventory/wand_k", fn, assets)